#include "General.h"
#include "RemoveWeaponChatCommand.h"
#include "engine_weap.h"
#include "weaponmgr.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "ArmedGameObj.h"
#include "WeaponBagClass.h"
#include "gmgame.h"

#define STYLE_C4 0 // note that this list reflects the list in leveledit
#define STYLE_BEACON 6

RemoveWeaponChatCommand::RemoveWeaponChatCommand()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

RemoveWeaponChatCommand::~RemoveWeaponChatCommand()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
}

#define GREEN "104,234,40"

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void Page(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

void Remove_Current_Weapon_From_Weaponbag(GameObject* obj)
{
	PhysicalGameObj *o2 = ((ScriptableGameObj *)obj)->As_PhysicalGameObj();
	if (!o2)
	{
		return;
	}
	ArmedGameObj *o3 = o2->As_ArmedGameObj();
	if (!o3)
	{
		return;
	}
	WeaponBagClass *w = o3->Get_Weapon_Bag();
	if ( w->Get_Index() && (w->Get_Index() < w->Get_Count()) )
	{
//		DynamicVectorClass<WeaponClass*>	*WeaponList;

//		_asm
//		{
//			mov ecx, [w+4h]
//			mov WeaponList, ecx
//		}
//		WeaponList->Delete(w->Get_Index());
//		w->Force_Changed();
	}
}

void Remove_Weapon_Command(int PlayerID)
{
	GameObject *obj = Get_GameObj(PlayerID);
	const char* CurrentWeapon = Get_Current_Weapon(obj);
	
	if (CurrentWeapon == NULL) return;

	const WeaponDefinitionClass *Def = Get_Current_Weapon_Definition(obj);

	if ( (Def->Style == STYLE_BEACON) ||  (Def->Style == STYLE_C4) || (strcmp(CurrentWeapon, "Weapon_Pistol_Player") == 0) ) 
	{
		Page(PlayerID, GREEN, "Error removing weapon; Can't remove Pistol, C4 and/or beacons.");
		return;
	}

//	Remove_Current_Weapon_From_Weaponbag(obj);
	Remove_Weapon(obj, CurrentWeapon);
	Commands->Select_Weapon(obj, Get_Weapon(obj, 1));
	Page(PlayerID, GREEN, "Removed weapon %s from your weapon bag.", CurrentWeapon);
}

bool RemoveWeaponChatCommand::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if ( (Message[0] == '!') )
	{
		StringClass Msg = Message;

		if ( !Msg.Compare_No_Case("!rw") || !Msg.Compare_No_Case("!rweapon") )
		{
			Send_Client_Text(Message, Type, FALSE, PlayerID, recieverID, true, true);
			Remove_Weapon_Command(PlayerID);			
			return false;
		}

	}
	return true;
}

RemoveWeaponChatCommand removeWeaponChatCommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &removeWeaponChatCommand;
}
